Triggers = {}

include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/end_trigger")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/kill_watcher")
include("campaigns/"..CAMPAIGN_NAME.."/Sectors/Triggers/quest_watcher")

Triggers["center_point"] = 
{
	active = false, 
	effect_radius = 20, 
	position = { x = 98.45, y = 105.2, z = 12, f = 1.0}, 
	priority = 1.0, 
	think = "tf_center_point", 
	type = "quest", 
}

Triggers["guard_1"] = 
{
	color = "0xFF0000", 
	guard_type = "random", 
	points = 0, 
	point_radius = 0.5, 
	position = { x = 128.1, y = 170.0, z = 11.9, f = 1.0}, 
	type = "guard", 
	wait_time = 0, 
	watch_points = {{ x=128.083, y=169.953, z=11.8773} }
}

Triggers["guard_2"] = 
{
	color = "0xFF0000", 
	guard_type = "random", 
	points = 0, 
	point_radius = 0.5, 
	position = { x = 129.6, y = 164.9, z = 11.9, f = 1.0}, 
	type = "guard", 
	wait_time = 0, 
	watch_points = {{ x=129.608, y=164.947, z=11.8773} }
}

Triggers["guard_3"] = 
{
	color = "0xFF0000", 
	guard_type = "random", 
	points = 0, 
	point_radius = 0.5, 
	position = { x = 124.3, y = 161.4, z = 11.9, f = 1.0}, 
	type = "guard", 
	wait_time = 0, 
	watch_points = {{ x=124.255, y=161.355, z=11.912} }
}

Triggers["guard_4"] = 
{
	color = "0xFF0000", 
	guard_type = "random", 
	points = 0, 
	point_radius = 0.5, 
	position = { x = 128.9, y = 162.0, z = 11.9, f = 1.0}, 
	type = "guard", 
	wait_time = 0, 
	watch_points = {{ x=128.905, y=161.989, z=11.912} }
}

Triggers["guard_karl"] = 
{
	color = "0xFF0000", 
	guard_type = "random", 
	points = 0, 
	point_radius = 0.5, 
	position = { x = 128.6, y = 167.3, z = 11.9, f = 1.0}, 
	type = "guard", 
	wait_time = 0, 
	watch_points = {{ x=128.564, y=167.343, z=11.8773} }
}
 
Triggers["carl_exit"] = 
{
	active = false, 
	effect_radius = 6, 
	position = { x = 9.6, y = 141.4, z = 10.9, f = 1.0}, 
	priority = 1.0, 
	think = "tf_carl_exit", 
	type = "quest", 
}

Triggers["carl_way_out"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "line", 
	point_count = 7, 
	point_radius = 2, 
	position = { x = 132.7, y = 144.4, z = 5.3, f = 1.0}, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=132.694, y=144.351, z=5.25026},{ x=128.468, y=141.257, z=4.12578},{ x=112.596, y=136.511, z=4.776},{ x=96.5764, y=135.295, z=7.30696},{ x=75.0857, y=137.238, z=8.11103},{ x=39.2641, y=139.752, z=8.16244},{ x=9.90289, y=141.207, z=10.8805} }
} 

Triggers["carl_gone"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_carl_gone", 
	type = "quest", 
}

Triggers["end_trigger"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=0, x=0, z=0, f=1 }, 
	priority = 1, 
	think = "tf_end_trigger", 
	type = "quest", 
}

Triggers["check_point"] = 
{
	active = false, 
	effect_radius = 21, 
	position = { y=92.3, x=109, z=2.8, f=1 }, 
	priority = 1, 
	think = "tf_check_point", 
	type = "quest", 
}

Triggers["despawn_patrol"] = 
{
	active = false, 
	effect_radius = 6, 
	position = { y=13.3, x=21.4, z=7.7, f=1 }, 
	priority = 1, 
	think = "tf_despawn_patrol", 
	type = "quest", 
}

Triggers["on_start"] = 
{
	active = true, 
	effect_radius = 10, 
	position = { x = 39.9, y = 43.5, z = 3.8, f = 1.0}, 
	priority = 1, 
	think = "tf_on_start", 
	type = "quest", 
}

Triggers["patrol_2"] = 
{
	color = "0xFF0000", 
	direction = 1, 
	line_dir = 1, 
	patrol_type = "once", 
	point_count = 10, 
	point_radius = 5, 
	position = { y=143.8, x=24.5, z=11, f=1 }, 
	transfer_mode = "walk", 
	type = "patrol", 
	wait_style = "none", 
	wait_time = 0, 
	patrol_points = {{ x=24.4795, y=143.826, z=11.0492},{ x=75.0139, y=135.948, z=8.40866},{ x=116.696, y=139.809, z=5.82144},{ x=141.666, y=141.993, z=3.58633},{ x=156.075, y=125.559, z=1.49116},{ x=147.791, y=108.949, z=3.55608},{ x=124.913, y=99.367, z=2.86703},{ x=90.3172, y=79.505, z=2.75193},{ x=58.5728, y=66.0915, z=4.06818},{ x=21.4203, y=14.0699, z=7.72201} }
}

Triggers["army_damagereactor"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=73.3, x=154.5, z=5.6, f=1 }, 
	priority = 1, 
	think = "tf_army_damagereactor", 
	type = "quest", 
}

Triggers["relations"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations", 
	type = "quest", 
}

Triggers["relations_vs_army"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=75.3, x=150.5, z=77.6, f=1 }, 
	priority = 1, 
	think = "tf_relations_vs_army", 
	type = "quest", 
}

Triggers["spawn_patrol"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=37.8, x=-77.7, z=11.1, f=1 }, 
	priority = 1, 
	think = "tf_spawn_patrol", 
	type = "quest", 
}

Triggers["pass_update"] = 
{
	active = false, 
	effect_radius = 3, 
	position = { y=37.8, x=-77.7, z=11.1, f=1 }, 
	priority = 1, 
	think = "tf_pass_update", 
	type = "quest", 
}

trigger_functions =
{
--
-- Makes Karl disappear
--
tf_carl_gone = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if((trigger.active == true) or ((relations(MARAUDERS, PLAYER) ~= ENEMY) and (isGameInRT()) and (getGVAR("NR_KARL_KILLED") == _YES) and (getGVAR("spawn_carl_nr") == _YES))) then
		trigger.active = false
		--
		local mod = function(unit)
			if (IsAlive(unit)) then
				Humans[unit].behavior = "patrol"
				Humans[unit].patrol_routine = "carl_way_out"
			else
				setGVAR("NR_"..unit.."_off", _YES)
			end
		end
		--
		mod("carl")
		mod("bandit1")
		mod("bandit2")
		mod("bandit3")
		mod("bandit4")
		--
		Triggers["carl_exit"].active = true
	end
end,
--
-- Checkpoint code
--
tf_check_point = function(trigger_id, time)
	
	if (Sectors.north_road.isDone) then
		return
	end

	local trigger = Triggers[trigger_id]
	
	if (trigger.active == true) then
	
		if ((getGVAR("NR_OFFICER_KILLED") == _YES) or (relations(ARMY, PLAYER) == ENEMY)) then
			trigger.active = false
			Triggers["spawn_patrol"].active = true
			return
		end
	
		checkPointer("north_road", trigger_id, {"army_1", "army_2", "army_3", "army_4"}, "checkpoint_remark1", "checkpoint_remark2", "check_point_01", 10, time, true, 30, "checkpoint_remark3", false)
		
		if (getGVAR("GOT_PAPERS") == _NO) then
			checkPointer("north_road", trigger_id, {"army_5", "army_6", "army_7", "army_8"}, "checkpoint_remark2", "checkpoint_remark2", nil, 0.5, time, true, 30, "checkpoint_remark3", true)
		end
	end
end,
--
-- Patrol despawn conditions
--
tf_despawn_patrol = function(trigger_id, time)
	local trigger = Triggers[trigger_id]

	local check = function(unit)
		if (getGVAR("NR_"..unit.."_off") ~= _YES) then
			if (IsAlive(unit)) then
				if (trigger_utility.isPersonPresent(trigger_id, unit)) then
					disappearHuman(unit)
				else
					return
				end
			end
			
			setGVAR("NR_"..unit.."_off", _YES)
		end
	end

	if(trigger.active == true) then
		if ((getGVAR("NR_officer_1_off") == _YES) and (getGVAR("NR_soldier_1_off") == _YES) and (getGVAR("NR_soldier_2_off") == _YES) and (getGVAR("NR_soldier_3_off") == _YES))then
			trigger.active = false
			return
		end
		
		check("officer_1")
		check("soldier_1")
		check("soldier_2")
		check("soldier_3")
	end
end,
--
-- Simple onStart stuff, kinda init.
--
tf_on_start = function(trigger_id, time)
	if Sectors.north_road.isDone then return end
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
--		setGVAR("NR_PASS_KNOWN", _YES)
		
		if (getGVAR("spawn_army_nr") == _YES) then
			--showObject("patrol_uaz", true) 		
			Triggers["check_point"].active = true
			Triggers["army_damagereactor"].active = true
		end
	end
end,
--
-- Damage Reactor for Army
--
tf_army_damagereactor = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		damageReactor(trigger_id, {"army_1","army_2","army_3","army_4","army_5","army_6","army_7","army_8"}, nil, nil)
	end
end,
--
-- Changes Local Relations with Marauders
--
tf_relations = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, MARAUDERS)		
		trigger.active = false
	end
end,
--
-- Changes Local relations with Army
--
tf_relations_vs_army = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		changeLocalRelations(ENEMY, ARMY)
		trigger.active = false
	end
end,
--
-- Spawns patrol after 10 minutes of peace or on combat start thru dialog with officer
--
tf_spawn_patrol = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	
	log(trigger_id, "Active:", trigger.active, "Time:", time)
	
	if(((trigger.active == true) or (time >= 600)) and (getGVAR("patrol_spawned_nr") == _NO)) then
		
		setGVAR("patrol_spawned_nr", _YES)
		
		log(trigger_id, "Road Block Owner:", Sectors["roadblock"].owner)

		trigger.active = false
		
		if(Sectors["roadblock"].owner == ARMY) then
			log(trigger_id, "Spawning")
			
			spawnHuman(ARMY, "officer_1")
			spawnHuman(ARMY, "soldier_1")
			spawnHuman(ARMY, "soldier_2")
			spawnHuman(ARMY, "soldier_3")
			Humans["officer_1"].patrol_routine = "patrol_2"
			Humans["soldier_1"].patrol_routine = "patrol_2"
			Humans["soldier_2"].patrol_routine = "patrol_2"
			Humans["soldier_3"].patrol_routine = "patrol_2"
			
			Triggers["despawn_patrol"].active = true
		end
	end
end,
--
--     
--
tf_carl_exit = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	
	local check = function(unit)
		if (getGVAR("NR_"..unit.."_off") ~= _YES) then
			if (IsAlive(unit)) then
				if (trigger_utility.isPersonPresent(trigger_id, unit)) then
					disappearHuman(unit)
				else
					return
				end
			end
			
			setGVAR("NR_"..unit.."_off", _YES)
		end
	end
	
	if(trigger.active == true) then
		if ((getGVAR("NR_carl_off") == _YES) and (getGVAR("NR_bandit1_off") == _YES) and (getGVAR("NR_bandit2_off") == _YES) and (getGVAR("NR_bandit3_off") == _YES) and (getGVAR("NR_bandit4_off") == _YES))then
			trigger.active = false
			return
		end
		
		check("carl")
		check("bandit1")
		check("bandit2")
		check("bandit3")
		check("bandit4")
	end

end,
--
-- Notify player that he got the pass papers
--
tf_pass_update = function(trigger_id, time)
	local trigger = Triggers[trigger_id]
	if(trigger.active == true) then
		trigger.active = false
		--addEntry("got_pass_papers", false)
	end
end, 
--
-- end trigger
--
tf_end_trigger = CommonTriggers.end_trigger,
--
-- kill watcher trigger
--
tf_kill_watcher = CommonTriggers.kill_watcher,
--
-- quest watcher trigger
--
tf_quest_watcher = CommonTriggers.quest_watcher,
--
-- honey point for bees
--
tf_center_point = CommonTriggers.center_point,
}
